/*
 * Decompiled with CFR 0.152.
 */
package de.sventorben.keycloak.authentication.hidpd;

import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriInfo;
import org.keycloak.authentication.AuthenticationFlowContext;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.services.managers.AuthenticationManager;

final class RememberMe {
    private final AuthenticationFlowContext context;

    public RememberMe(AuthenticationFlowContext context) {
        this.context = context;
    }

    void remember(String username) {
        boolean remember;
        String rememberMe = this.context.getAuthenticationSession().getAuthNote("remember_me");
        RealmModel realm = this.context.getRealm();
        boolean bl = remember = realm.isRememberMe() && "true".equalsIgnoreCase(rememberMe);
        if (remember) {
            AuthenticationManager.createRememberMeCookie((String)username, (UriInfo)this.context.getUriInfo(), (KeycloakSession)this.context.getSession());
        } else {
            AuthenticationManager.expireRememberMeCookie((RealmModel)realm, (UriInfo)this.context.getUriInfo(), (KeycloakSession)this.context.getSession());
        }
    }

    void handleAction(MultivaluedMap<String, String> formData) {
        boolean remember;
        boolean bl = remember = this.context.getRealm().isRememberMe() && "on".equalsIgnoreCase((String)formData.getFirst((Object)"rememberMe"));
        if (remember) {
            this.context.getAuthenticationSession().setAuthNote("remember_me", "true");
            this.context.getEvent().detail("remember_me", "true");
        } else {
            this.context.getAuthenticationSession().removeAuthNote("remember_me");
        }
    }

    String getUserName() {
        return AuthenticationManager.getRememberMeUsername((RealmModel)this.context.getRealm(), (HttpHeaders)this.context.getHttpRequest().getHttpHeaders());
    }
}

