/*
 * Decompiled with CFR 0.152.
 */
package de.sventorben.keycloak.authentication.hidpd;

import de.sventorben.keycloak.authentication.hidpd.HomeIdpAuthenticationFlowContext;
import java.net.URI;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.jboss.logging.Logger;
import org.keycloak.authentication.AuthenticationFlowContext;
import org.keycloak.broker.provider.AuthenticationRequest;
import org.keycloak.broker.provider.IdentityProvider;
import org.keycloak.broker.provider.IdentityProviderFactory;
import org.keycloak.broker.provider.util.IdentityBrokerState;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakUriInfo;
import org.keycloak.models.RealmModel;
import org.keycloak.services.Urls;
import org.keycloak.services.managers.ClientSessionCode;
import org.keycloak.services.resources.IdentityBrokerService;
import org.keycloak.sessions.AuthenticationSessionModel;
import org.keycloak.sessions.CommonClientSessionModel;

final class Redirector {
    private static final Logger LOG = Logger.getLogger(Redirector.class);
    private final AuthenticationFlowContext context;

    Redirector(AuthenticationFlowContext context) {
        this.context = context;
    }

    void redirectTo(IdentityProviderModel idp) {
        String providerAlias = idp.getAlias();
        RealmModel realm = this.context.getRealm();
        AuthenticationSessionModel authenticationSession = this.context.getAuthenticationSession();
        KeycloakSession keycloakSession = this.context.getSession();
        ClientSessionCode clientSessionCode = new ClientSessionCode(keycloakSession, realm, (CommonClientSessionModel)authenticationSession);
        clientSessionCode.setAction(CommonClientSessionModel.Action.AUTHENTICATE.name());
        if (!idp.isEnabled()) {
            LOG.warnf("Identity Provider %s is disabled.", (Object)providerAlias);
            return;
        }
        if (idp.isLinkOnly()) {
            LOG.warnf("Identity Provider %s is not allowed to perform a login.", (Object)providerAlias);
            return;
        }
        new HomeIdpAuthenticationFlowContext(this.context).loginHint().copyTo((ClientSessionCode<AuthenticationSessionModel>)clientSessionCode);
        IdentityProviderFactory providerFactory = IdentityBrokerService.getIdentityProviderFactory((KeycloakSession)keycloakSession, (IdentityProviderModel)idp);
        IdentityProvider identityProvider = providerFactory.create(keycloakSession, idp);
        Response response = identityProvider.performLogin(this.createAuthenticationRequest(providerAlias, (ClientSessionCode<AuthenticationSessionModel>)clientSessionCode));
        this.context.forceChallenge(response);
    }

    private AuthenticationRequest createAuthenticationRequest(String providerId, ClientSessionCode<AuthenticationSessionModel> clientSessionCode) {
        AuthenticationSessionModel authSession = null;
        IdentityBrokerState encodedState = null;
        if (clientSessionCode != null) {
            authSession = (AuthenticationSessionModel)clientSessionCode.getClientSession();
            String relayState = clientSessionCode.getOrGenerateCode();
            encodedState = IdentityBrokerState.decoded((String)relayState, (String)authSession.getClient().getId(), (String)authSession.getClient().getClientId(), (String)authSession.getTabId());
        }
        KeycloakSession keycloakSession = this.context.getSession();
        KeycloakUriInfo keycloakUriInfo = keycloakSession.getContext().getUri();
        RealmModel realm = this.context.getRealm();
        String redirectUri = Urls.identityProviderAuthnResponse((URI)keycloakUriInfo.getBaseUri(), (String)providerId, (String)realm.getName()).toString();
        return new AuthenticationRequest(keycloakSession, realm, authSession, this.context.getHttpRequest(), (UriInfo)keycloakUriInfo, encodedState, redirectUri);
    }
}

