/*
 * Decompiled with CFR 0.152.
 */
package de.sventorben.keycloak.authentication.hidpd;

import de.sventorben.keycloak.authentication.hidpd.HomeIdpDiscoveryConfig;
import java.util.Set;
import org.jboss.logging.Logger;
import org.keycloak.authentication.AuthenticationFlowContext;
import org.keycloak.sessions.AuthenticationSessionModel;
import org.keycloak.util.TokenUtil;

class LoginPage {
    private static final Logger LOG = Logger.getLogger(LoginPage.class);
    private static final Set<String> OIDC_PROMPT_NO_BYPASS = Set.of("login", "consent", "select_account");
    private final AuthenticationFlowContext context;
    private final HomeIdpDiscoveryConfig config;

    LoginPage(AuthenticationFlowContext context, HomeIdpDiscoveryConfig config) {
        this.context = context;
        this.config = config;
    }

    boolean shouldByPass() {
        boolean bypassLoginPage = this.config.bypassLoginPage();
        if (bypassLoginPage) {
            AuthenticationSessionModel authenticationSession = this.context.getAuthenticationSession();
            String prompt = authenticationSession.getClientNote("prompt");
            if (OIDC_PROMPT_NO_BYPASS.stream().anyMatch(it -> TokenUtil.hasPrompt((String)prompt, (String)it))) {
                LOG.debugf("OIDC: Forced by prompt=%s", (Object)prompt);
                return false;
            }
            if ("true".equalsIgnoreCase(authenticationSession.getAuthNote("SAML_LOGIN_REQUEST_FORCEAUTHN"))) {
                LOG.debugf("SAML: Forced authentication", new Object[0]);
                return false;
            }
        }
        return bypassLoginPage;
    }
}

