/*
 * Decompiled with CFR 0.152.
 */
package de.sventorben.keycloak.authentication.hidpd;

import de.sventorben.keycloak.authentication.hidpd.AlwaysSelectableIdentityProviderModel;
import de.sventorben.keycloak.authentication.hidpd.BaseUriLoginFormsProvider;
import java.net.URI;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.keycloak.authentication.AuthenticationFlowContext;
import org.keycloak.forms.login.LoginFormsProvider;
import org.keycloak.forms.login.freemarker.model.IdentityProviderBean;
import org.keycloak.models.IdentityProviderModel;

final class LoginForm {
    private final AuthenticationFlowContext context;
    private final BaseUriLoginFormsProvider loginFormsProvider;

    LoginForm(AuthenticationFlowContext context, BaseUriLoginFormsProvider loginFormsProvider) {
        this.context = context;
        this.loginFormsProvider = loginFormsProvider;
    }

    Response create(MultivaluedMap<String, String> formData) {
        LoginFormsProvider forms = this.context.form();
        if (!formData.isEmpty()) {
            forms.setFormData(formData);
        }
        return forms.createLoginUsername();
    }

    Response create(List<IdentityProviderModel> idps) {
        URI baseUriWithCodeAndClientId = this.loginFormsProvider.getBaseUriWithCodeAndClientId();
        LoginFormsProvider forms = this.context.form();
        forms.setAttribute("hidpd", (Object)new IdentityProviderBean(this.context.getRealm(), this.context.getSession(), idps.stream().map(AlwaysSelectableIdentityProviderModel::new).collect(Collectors.toList()), baseUriWithCodeAndClientId));
        return forms.createForm("hidpd-select-idp.ftl");
    }
}

