/*
 * Decompiled with CFR 0.152.
 */
package de.sventorben.keycloak.authentication.hidpd;

import de.sventorben.keycloak.authentication.hidpd.HomeIdpAuthenticationFlowContext;
import java.util.List;
import org.jboss.logging.Logger;
import org.keycloak.authentication.AuthenticationFlowContext;
import org.keycloak.authentication.Authenticator;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.KeycloakModelUtils;

final class HomeIdpDiscoveryLoginHintAuthenticator
implements Authenticator {
    private static final Logger LOG = Logger.getLogger(HomeIdpDiscoveryLoginHintAuthenticator.class);

    HomeIdpDiscoveryLoginHintAuthenticator() {
    }

    public void authenticate(AuthenticationFlowContext authenticationFlowContext) {
        HomeIdpAuthenticationFlowContext context = new HomeIdpAuthenticationFlowContext(authenticationFlowContext);
        String loginHint = this.trimToNull(context.loginHint().getFromSession());
        if (loginHint != null) {
            List<IdentityProviderModel> homeIdps;
            String username = this.setUserInContext(authenticationFlowContext, loginHint);
            if (authenticationFlowContext.getUser() == null && (homeIdps = context.discoverer().discoverForUser(username)).size() == 1) {
                IdentityProviderModel homeIdp = homeIdps.get(0);
                context.loginHint().setInAuthSession(homeIdp, username);
                context.redirector().redirectTo(homeIdp);
                return;
            }
        }
        authenticationFlowContext.clearUser();
        authenticationFlowContext.attempted();
    }

    public void action(AuthenticationFlowContext authenticationFlowContext) {
    }

    private String setUserInContext(AuthenticationFlowContext context, String username) {
        context.clearUser();
        username = this.trimToNull(username);
        if (username == null) {
            LOG.warn((Object)"No or empty username found in request");
            context.getEvent().error("user_not_found");
            context.attempted();
            return null;
        }
        LOG.debugf("Found username '%s' in request", (Object)username);
        context.getEvent().detail("username", username);
        context.getAuthenticationSession().setAuthNote("ATTEMPTED_USERNAME", username);
        context.getAuthenticationSession().setClientNote("login_hint", username);
        try {
            UserModel user = KeycloakModelUtils.findUserByNameOrEmail((KeycloakSession)context.getSession(), (RealmModel)context.getRealm(), (String)username);
            if (user != null) {
                LOG.tracef("Setting user '%s' in context", (Object)user.getId());
                context.setUser(user);
            }
        }
        catch (ModelDuplicateException ex) {
            LOG.warnf((Throwable)ex, "Could not uniquely identify the user. Multiple users with name or email '%s' found.", (Object)username);
        }
        return username;
    }

    private String trimToNull(String username) {
        if (username != null && "".equalsIgnoreCase(username = username.trim())) {
            username = null;
        }
        return username;
    }

    public boolean requiresUser() {
        return false;
    }

    public boolean configuredFor(KeycloakSession session, RealmModel realm, UserModel user) {
        return true;
    }

    public void setRequiredActions(KeycloakSession session, RealmModel realm, UserModel user) {
    }

    public void close() {
    }
}

