/*
 * Decompiled with CFR 0.152.
 */
package de.sventorben.keycloak.authentication.hidpd;

import de.sventorben.keycloak.authentication.hidpd.AuthenticationChallenge;
import de.sventorben.keycloak.authentication.hidpd.BaseUriLoginFormsProvider;
import de.sventorben.keycloak.authentication.hidpd.HomeIdpDiscoverer;
import de.sventorben.keycloak.authentication.hidpd.HomeIdpDiscoveryConfig;
import de.sventorben.keycloak.authentication.hidpd.LoginForm;
import de.sventorben.keycloak.authentication.hidpd.LoginHint;
import de.sventorben.keycloak.authentication.hidpd.LoginPage;
import de.sventorben.keycloak.authentication.hidpd.Redirector;
import de.sventorben.keycloak.authentication.hidpd.RememberMe;
import org.keycloak.authentication.AuthenticationFlowContext;

final class HomeIdpAuthenticationFlowContext {
    private final AuthenticationFlowContext context;
    private HomeIdpDiscoveryConfig config;
    private LoginPage loginPage;
    private LoginHint loginHint;
    private HomeIdpDiscoverer discoverer;
    private RememberMe rememberMe;
    private AuthenticationChallenge authenticationChallenge;
    private Redirector redirector;
    private BaseUriLoginFormsProvider loginFormsProvider;
    private LoginForm loginForm;

    HomeIdpAuthenticationFlowContext(AuthenticationFlowContext context) {
        this.context = context;
    }

    HomeIdpDiscoveryConfig config() {
        if (this.config == null) {
            this.config = new HomeIdpDiscoveryConfig(this.context.getAuthenticatorConfig());
        }
        return this.config;
    }

    LoginPage loginPage() {
        if (this.loginPage == null) {
            this.loginPage = new LoginPage(this.context, this.config());
        }
        return this.loginPage;
    }

    LoginHint loginHint() {
        if (this.loginHint == null) {
            this.loginHint = new LoginHint(this.context);
        }
        return this.loginHint;
    }

    HomeIdpDiscoverer discoverer() {
        if (this.discoverer == null) {
            this.discoverer = new HomeIdpDiscoverer(this.context);
        }
        return this.discoverer;
    }

    RememberMe rememberMe() {
        if (this.rememberMe == null) {
            this.rememberMe = new RememberMe(this.context);
        }
        return this.rememberMe;
    }

    AuthenticationChallenge authenticationChallenge() {
        if (this.authenticationChallenge == null) {
            this.authenticationChallenge = new AuthenticationChallenge(this.context, this.rememberMe(), this.loginHint(), this.loginForm());
        }
        return this.authenticationChallenge;
    }

    Redirector redirector() {
        if (this.redirector == null) {
            this.redirector = new Redirector(this.context);
        }
        return this.redirector;
    }

    LoginForm loginForm() {
        if (this.loginForm == null) {
            this.loginForm = new LoginForm(this.context, this.loginFormsProvider());
        }
        return this.loginForm;
    }

    BaseUriLoginFormsProvider loginFormsProvider() {
        if (this.loginFormsProvider == null) {
            this.loginFormsProvider = new BaseUriLoginFormsProvider(this.context);
        }
        return this.loginFormsProvider;
    }
}

