/*
 * Decompiled with CFR 0.152.
 */
package de.sventorben.keycloak.authentication.hidpd;

import de.sventorben.keycloak.authentication.hidpd.HomeIdpDiscoveryConfig;
import java.util.Optional;
import org.jboss.logging.Logger;
import org.keycloak.models.UserModel;

final class DomainExtractor {
    private static final Logger LOG = Logger.getLogger(DomainExtractor.class);
    private static final String EMAIL_ATTRIBUTE = "email";
    private final HomeIdpDiscoveryConfig config;

    DomainExtractor(HomeIdpDiscoveryConfig config) {
        this.config = config;
    }

    Optional<String> extractFrom(UserModel user) {
        if (!user.isEnabled()) {
            LOG.warnf("User '%s' not enabled", (Object)user.getId());
            return Optional.empty();
        }
        String userAttribute = user.getFirstAttribute(this.config.userAttribute());
        if (userAttribute == null) {
            LOG.warnf("Could not find user attribute '%s' for user '%s'", (Object)this.config.userAttribute(), (Object)user.getId());
            return Optional.empty();
        }
        if (EMAIL_ATTRIBUTE.equalsIgnoreCase(this.config.userAttribute()) && !user.isEmailVerified()) {
            LOG.warnf("Email address of user '%s' is not verified", (Object)user.getId());
            return Optional.empty();
        }
        return this.extractFrom(userAttribute);
    }

    Optional<String> extractFrom(String usernameOrEmail) {
        String email;
        int atIndex;
        String domain = null;
        if (usernameOrEmail != null && (atIndex = usernameOrEmail.trim().lastIndexOf("@")) >= 0 && (domain = (email = usernameOrEmail).substring(atIndex + 1).trim()).length() == 0) {
            domain = null;
        }
        return Optional.ofNullable(domain);
    }
}

