/*
 * Decompiled with CFR 0.152.
 */
package de.sventorben.keycloak.authentication.hidpd;

import de.sventorben.keycloak.authentication.hidpd.LoginForm;
import de.sventorben.keycloak.authentication.hidpd.LoginHint;
import de.sventorben.keycloak.authentication.hidpd.RememberMe;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.specimpl.MultivaluedMapImpl;
import org.keycloak.authentication.AuthenticationFlowContext;
import org.keycloak.models.IdentityProviderModel;

final class AuthenticationChallenge {
    private final AuthenticationFlowContext context;
    private final RememberMe rememberMe;
    private final LoginHint loginHint;
    private final LoginForm loginForm;

    AuthenticationChallenge(AuthenticationFlowContext context, RememberMe rememberMe, LoginHint loginHint, LoginForm loginForm) {
        this.context = context;
        this.rememberMe = rememberMe;
        this.loginHint = loginHint;
        this.loginForm = loginForm;
    }

    void forceChallenge() {
        MultivaluedMapImpl formData = new MultivaluedMapImpl();
        String loginHintUsername = this.loginHint.getFromSession();
        String rememberMeUsername = this.rememberMe.getUserName();
        if (loginHintUsername != null || rememberMeUsername != null) {
            if (loginHintUsername != null) {
                formData.add((Object)"username", (Object)loginHintUsername);
            } else {
                formData.add((Object)"username", (Object)rememberMeUsername);
                formData.add((Object)"rememberMe", (Object)"on");
            }
        }
        Response challengeResponse = this.loginForm.create((MultivaluedMap<String, String>)formData);
        this.context.challenge(challengeResponse);
    }

    void forceChallenge(List<IdentityProviderModel> homeIdps) {
        this.context.forceChallenge(this.loginForm.create(homeIdps));
    }
}

